/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.task;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.task.PresentationTask;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.task.TaskErrorIds;
import com.ibm.hwmca.fw.util.Trace;

public class ProgramPresentationTask
extends PresentationTask
implements TaskErrorIds {
    private static final String TRACE_MASKT = "XFRMPGTT";
    private static final String TRACE_MASKF = "XFRMPGTF";
    private static final String TRACE_MASKD = "XFRMPGTD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "PgmPresTask");
    private Process pgm = null;

    public ProgramPresentationTask(PresentationTaskParms parms) {
        super(parms);
        Trace.trace(TRACE_MASKT, "<> ProgramPresentationTask constructor");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> ProgramPresentationTask.logException()");
        Trace.trace(TRACE_MASKT, "processing exception: " + throwable);
        new FrameworkLog(classLogInfo, 74, throwable).log();
        Trace.trace(TRACE_MASKT, "<- ProgramPresentationTask.logException()");
    }

    protected void forceTermination(String reason) {
        Trace.trace(TRACE_MASKF, "-> ProgramPresentationTask.forceTermination()");
        if (this.pgm != null) {
            this.pgm.destroy();
        }
        Trace.trace(TRACE_MASKF, "<- ProgramPresentationTask.forceTermination()");
    }

    protected Object runTask() throws Exception {
        Trace.trace(TRACE_MASKF, "-> ProgramPresentationTask.runTask()");
        ObjectId taskId = this.parms.getTaskId();
        String key = (String)this.parms.getTaskId().getKeyProperty("Name");
        Trace.trace(TRACE_MASKF, "key=" + key);
        String[] parts = key.split(";");
        if (parts != null && parts.length > 1 && parts[1] != null) {
            Trace.trace(TRACE_MASKF, "executing cmd=[" + parts[1] + "]");
            try {
                HMCSession session = this.getHMCSession();
                Trace.trace(TRACE_MASKF, "session is: " + session);
                this.pgm = Runtime.getRuntime().exec(parts[1]);
                if (session != null) {
                    session.taskIsRealized(this.getPanelModelTaskPortal());
                }
                this.pgm.waitFor();
                this.pgm = null;
            }
            catch (Exception e) {
                this.logException(e);
            }
        } else {
            Trace.trace(TRACE_MASKF, "invalid key encountered");
            this.logException(new RuntimeException("Invalid task key encountered"));
        }
        Trace.trace(TRACE_MASKF, "<- ProgramPresentationTask.runTask()");
        return null;
    }
}

